﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;
using System.Runtime.Serialization;
namespace AZVIC.Ei8htPOS.Entities
{
    [Serializable]
    [DataContract]
    public class ProductsXCategory : BusinessBaseClass
    {

        public ProductsXCategory()
        {

        }

        public ProductsXCategory(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductsXCategoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductsXCategoryID"));
            ProductsID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductsID"));
            ProductCategoryID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductCategoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductCategoryID"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        [DataMember]
        public override Guid UniqueID { get; set; }
        [DataMember]
        public Guid ProductsID { get; set; }
        [DataMember]
        public Guid ProductCategoryID { get; set; }
        [DataMember]
        public Guid UserAccountID { get; set; }
        [DataMember]
        public override DateTime CreatedDate { get; set; }
        [DataMember]
        public override DateTime ModifiedDate { get; set; }
        [DataMember]
        public override GlobalConfigurations.Mode Mode { get; set; }
        [DataMember]
        public override bool IsActive { get; set; }
    }
}
